/****** Object:  StoredProcedure [dbo].[P_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_PROC_EXECUTE_ALL]    Script Date: 11/07/2013 18:13:23 ******/
IF EXISTS( SELECT * FROM sys.objects
				WHERE  object_id = OBJECT_ID(N'[dbo].[P_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_PROC_EXECUTE_ALL]')
					   AND type IN(N'P', N'PC')
)
	BEGIN
		DROP PROCEDURE [dbo].[P_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_PROC_EXECUTE_ALL];
	END;
GO
GO
GO
--EXEC P_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_PROC_EXECUTE_ALL 0
CREATE PROCEDURE [dbo].[P_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_PROC_EXECUTE_ALL] @CD_FILIAL_PAR INT = 0 
WITH ENCRYPTION AS
	 BEGIN
		 PRINT 'Inicio da gravacao dos parametros para calculo de demanda';
		 SET NOCOUNT ON;
		 DECLARE @CD_FILIAL INT;
		 DECLARE @CD_EMP INT=1;
		 
		 DECLARE @FLAG_NOVO_MODELO_PARAMETROS INT;
		 
		 SET @FLAG_NOVO_MODELO_PARAMETROS = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG
															WHERE  CD_EMP = 1
																   AND CD_CHAVE = 'FLAG_USA_NOVO_MODELO_PARAMETROS' ), 0);

		 IF @FLAG_NOVO_MODELO_PARAMETROS = 0 --Nao usa novo modelo de parametro
			 BEGIN
				TRUNCATE TABLE EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD;
			 END

		 DECLARE ProcPrecoRollback CURSOR FAST_FORWARD
		 FOR 
			SELECT
				CD_EMP
				, CD_FILIAL
			FROM
				PRC_FILIAL
			WHERE  
				CD_FILIAL = CASE WHEN @CD_FILIAL_PAR > 0 THEN @CD_FILIAL_PAR
								ELSE CD_FILIAL END
			ORDER BY CD_FILIAL;

		 OPEN ProcPrecoRollback;

		 FETCH NEXT FROM ProcPrecoRollback INTO @CD_EMP , @CD_FILIAL;

		 WHILE @@FETCH_STATUS = 0
			 BEGIN
				 PRINT 'Filial '+CONVERT(VARCHAR(10), @CD_FILIAL)+' '+CONVERT(VARCHAR, GETDATE(), 108);

				 EXEC P_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_PROC @CD_EMP , @CD_FILIAL;

				 FETCH NEXT FROM ProcPrecoRollback INTO @CD_EMP , @CD_FILIAL;
			 END;
		 PRINT 'Concluido.';
		 CLOSE ProcPrecoRollback;
		 DEALLOCATE ProcPrecoRollback;
	 END;